//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
struct stComplex
{
    private:
//+----------------+
        double re;
        double im;
//+----------------+
    public  :
//+----------------+
        stComplex() :re(0), im(0) {} 
//+----------------+
        stComplex(const stComplex &o) :re(o.re), im(o.im) {}
//+----------------+
        stComplex(const double r, const double i) :re(r), im(i) {} 
//+----------------+
        stComplex operator+=(const stComplex &arg)
        {
            this = this + arg;            
            return this;
        }
//+----------------+
        stComplex operator+(const stComplex &arg)
        {
            stComplex res;

            res.re = this.re + arg.re;
            res.im = this.im + arg.im;

            return res;
        };
//+----------------+
        void GetInfos(double &r, double &i) { r = re; i = im; }
//+----------------+
};
//+------------------------------------------------------------------+
#define PrintX(x) { double r, i; x.GetInfos(r, i); Print(__LINE__, " :: ", #x, " -> ", r, " ", i, "i"); }
//+------------------------------------------------------------------+
void OnStart(void)
{
    stComplex   a(2, 5),
                b(8, -3),
                c;

    c = a;
    PrintX(a);
    PrintX(b);
    PrintX(c);
    PrintX((a + b));
    PrintX((a += b));
    c += b;
    PrintX(c);
}
//+------------------------------------------------------------------+